//
//  MCSQLiteConnection.h
//  MCSQLitePersistence
//
//  Created by Eric Hochmeister on Tue Dec 14 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <MCFoundation/MCPDatabaseConnection.h>

@class MCSQLiteContext;

@interface MCSQLiteConnection : MCPDatabaseConnection {

	MCSQLiteContext* _dbAdaptor;
	
	NSMutableArray* _deletedObjects;
    
    NSNumber* pkeyOffset; // amount to add to a pkey for this database
    NSNumber* pkeyIncrement; // amount to add to the pkey sequence

}

- (id)initWithFile:(NSString*)inPath model: (MCPModel*)aModel;
- (id)initWithFile:(NSString*)inPath synchronous:(NSString*)syncFlag model: (MCPModel*)aModel;
- (id)initWithFile:(NSString*)inPath synchronous:(NSString*)syncFlag journal:(NSString*)journalFlag model: (MCPModel*)aModel;

- (id)initWithFile:(NSString*)inPath DEPRECATED_ATTRIBUTE;
- (id)initWithFile:(NSString*)inPath synchronous:(NSString*)syncFlag DEPRECATED_ATTRIBUTE;

- (MCSQLiteContext*)databaseAdaptor;

- (void)dealloc;

+ (NSString*)prepareStringForQuery:(NSString*)inString;

- (BOOL)createSchemaWithModel:(MCPModel*)aModel;

- (BOOL)populateDefaultValues:(NSArray*)valueArray;

- (NSData *)convertStringToData:(NSString *)string;

- (NSException *)executeStringSQL:(NSString *)sql;

- (NSNumber*)pkeyOffset;
- (void)setPkeyOffset: (NSNumber*)aNumber;
- (NSNumber*)pkeyIncrement;
- (void)setPkeyIncrement: (NSNumber*)aNumber;

@end
